/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.pathprovider;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.NonNull;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.flutter.embedding.engine.plugins.FlutterPlugin;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import io.flutter.plugin.common.MethodCodec;
import io.flutter.plugin.common.PluginRegistry;
import io.flutter.plugin.common.StandardMethodCodec;
import io.flutter.plugins.pathprovider.StorageDirectoryMapper;
import io.flutter.util.PathUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class PathProviderPlugin
implements FlutterPlugin,
MethodChannel.MethodCallHandler {
    static final String TAG = "PathProviderPlugin";
    private Context context;
    private MethodChannel channel;
    private PathProviderImpl impl;

    private void setup(BinaryMessenger messenger, Context context) {
        String channelName = "plugins.flutter.io/path_provider_android";
        BinaryMessenger.TaskQueue taskQueue = messenger.makeBackgroundTaskQueue();
        try {
            this.channel = new MethodChannel(messenger, channelName, (MethodCodec)StandardMethodCodec.INSTANCE, taskQueue);
            this.impl = new PathProviderBackgroundThread();
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)"Received exception while setting up PathProviderPlugin", (Throwable)ex);
        }
        this.context = context;
        this.channel.setMethodCallHandler((MethodChannel.MethodCallHandler)this);
    }

    public static void registerWith(PluginRegistry.Registrar registrar) {
        PathProviderPlugin instance = new PathProviderPlugin();
        instance.setup(registrar.messenger(), registrar.context());
    }

    public void onAttachedToEngine(@NonNull FlutterPlugin.FlutterPluginBinding binding) {
        this.setup(binding.getBinaryMessenger(), binding.getApplicationContext());
    }

    public void onDetachedFromEngine(@NonNull FlutterPlugin.FlutterPluginBinding binding) {
        this.channel.setMethodCallHandler(null);
        this.channel = null;
    }

    public void onMethodCall(MethodCall call, @NonNull MethodChannel.Result result) {
        switch (call.method) {
            case "getTemporaryDirectory": {
                this.impl.getTemporaryDirectory(result);
                break;
            }
            case "getApplicationDocumentsDirectory": {
                this.impl.getApplicationDocumentsDirectory(result);
                break;
            }
            case "getStorageDirectory": {
                this.impl.getStorageDirectory(result);
                break;
            }
            case "getExternalCacheDirectories": {
                this.impl.getExternalCacheDirectories(result);
                break;
            }
            case "getExternalStorageDirectories": {
                Integer type = (Integer)call.argument("type");
                String directoryName = StorageDirectoryMapper.androidType(type);
                this.impl.getExternalStorageDirectories(directoryName, result);
                break;
            }
            case "getApplicationSupportDirectory": {
                this.impl.getApplicationSupportDirectory(result);
                break;
            }
            default: {
                result.notImplemented();
            }
        }
    }

    private String getPathProviderTemporaryDirectory() {
        return this.context.getCacheDir().getPath();
    }

    private String getApplicationSupportDirectory() {
        return PathUtils.getFilesDir((Context)this.context);
    }

    private String getPathProviderApplicationDocumentsDirectory() {
        return PathUtils.getDataDirectory((Context)this.context);
    }

    private String getPathProviderStorageDirectory() {
        File dir = this.context.getExternalFilesDir(null);
        if (dir == null) {
            return null;
        }
        return dir.getAbsolutePath();
    }

    private List<String> getPathProviderExternalCacheDirectories() {
        ArrayList<String> paths = new ArrayList<String>();
        if (Build.VERSION.SDK_INT >= 19) {
            for (File dir : this.context.getExternalCacheDirs()) {
                if (dir == null) continue;
                paths.add(dir.getAbsolutePath());
            }
        } else {
            File dir = this.context.getExternalCacheDir();
            if (dir != null) {
                paths.add(dir.getAbsolutePath());
            }
        }
        return paths;
    }

    private List<String> getPathProviderExternalStorageDirectories(String type) {
        ArrayList<String> paths = new ArrayList<String>();
        if (Build.VERSION.SDK_INT >= 19) {
            for (File dir : this.context.getExternalFilesDirs(type)) {
                if (dir == null) continue;
                paths.add(dir.getAbsolutePath());
            }
        } else {
            File dir = this.context.getExternalFilesDir(type);
            if (dir != null) {
                paths.add(dir.getAbsolutePath());
            }
        }
        return paths;
    }

    private static class UiThreadExecutor
    implements Executor {
        private final Handler handler = new Handler(Looper.getMainLooper());

        private UiThreadExecutor() {
        }

        @Override
        public void execute(Runnable command) {
            this.handler.post(command);
        }
    }

    private class PathProviderBackgroundThread
    implements PathProviderImpl {
        private PathProviderBackgroundThread() {
        }

        @Override
        public void getTemporaryDirectory(@NonNull MethodChannel.Result result) {
            result.success((Object)PathProviderPlugin.this.getPathProviderTemporaryDirectory());
        }

        @Override
        public void getApplicationDocumentsDirectory(@NonNull MethodChannel.Result result) {
            result.success((Object)PathProviderPlugin.this.getPathProviderApplicationDocumentsDirectory());
        }

        @Override
        public void getStorageDirectory(@NonNull MethodChannel.Result result) {
            result.success((Object)PathProviderPlugin.this.getPathProviderStorageDirectory());
        }

        @Override
        public void getExternalCacheDirectories(@NonNull MethodChannel.Result result) {
            result.success((Object)PathProviderPlugin.this.getPathProviderExternalCacheDirectories());
        }

        @Override
        public void getExternalStorageDirectories(@NonNull String directoryName, @NonNull MethodChannel.Result result) {
            result.success((Object)PathProviderPlugin.this.getPathProviderExternalStorageDirectories(directoryName));
        }

        @Override
        public void getApplicationSupportDirectory(@NonNull MethodChannel.Result result) {
            result.success((Object)PathProviderPlugin.this.getApplicationSupportDirectory());
        }
    }

    private class PathProviderPlatformThread
    implements PathProviderImpl {
        private final Executor uiThreadExecutor = new UiThreadExecutor();
        private final Executor executor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("path-provider-background-%d").setPriority(5).build());

        private PathProviderPlatformThread() {
        }

        @Override
        public void getTemporaryDirectory(@NonNull MethodChannel.Result result) {
            this.executeInBackground(() -> PathProviderPlugin.this.getPathProviderTemporaryDirectory(), result);
        }

        @Override
        public void getApplicationDocumentsDirectory(@NonNull MethodChannel.Result result) {
            this.executeInBackground(() -> PathProviderPlugin.this.getPathProviderApplicationDocumentsDirectory(), result);
        }

        @Override
        public void getStorageDirectory(@NonNull MethodChannel.Result result) {
            this.executeInBackground(() -> PathProviderPlugin.this.getPathProviderStorageDirectory(), result);
        }

        @Override
        public void getExternalCacheDirectories(@NonNull MethodChannel.Result result) {
            this.executeInBackground(() -> PathProviderPlugin.this.getPathProviderExternalCacheDirectories(), result);
        }

        @Override
        public void getExternalStorageDirectories(@NonNull String directoryName, @NonNull MethodChannel.Result result) {
            this.executeInBackground(() -> PathProviderPlugin.this.getPathProviderExternalStorageDirectories(directoryName), result);
        }

        @Override
        public void getApplicationSupportDirectory(@NonNull MethodChannel.Result result) {
            this.executeInBackground(() -> PathProviderPlugin.this.getApplicationSupportDirectory(), result);
        }

        private <T> void executeInBackground(Callable<T> task, final MethodChannel.Result result) {
            SettableFuture future = SettableFuture.create();
            Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<T>(){

                public void onSuccess(T answer) {
                    result.success(answer);
                }

                public void onFailure(Throwable t) {
                    result.error(t.getClass().getName(), t.getMessage(), null);
                }
            }, (Executor)this.uiThreadExecutor);
            this.executor.execute(() -> {
                try {
                    future.set(task.call());
                }
                catch (Throwable t) {
                    future.setException(t);
                }
            });
        }
    }

    private static interface PathProviderImpl {
        public void getTemporaryDirectory(@NonNull MethodChannel.Result var1);

        public void getApplicationDocumentsDirectory(@NonNull MethodChannel.Result var1);

        public void getStorageDirectory(@NonNull MethodChannel.Result var1);

        public void getExternalCacheDirectories(@NonNull MethodChannel.Result var1);

        public void getExternalStorageDirectories(@NonNull String var1, @NonNull MethodChannel.Result var2);

        public void getApplicationSupportDirectory(@NonNull MethodChannel.Result var1);
    }
}

